from django.db import models

class AccountPG(models.Model):
    id = models.AutoField(primary_key=True)  # Auto-increment integer ID
    email = models.EmailField(unique=True)
    monogo_user_id = models.CharField(max_length=24, unique=True)  # changed here # ID from MongoDB user
    username = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)  # Set on create
    updated_at = models.DateTimeField(auto_now=True)      # Updated on save
    deleted_at = models.DateTimeField(null=True, blank=True)  # Nullable

    class Meta:
        db_table = 'ranker_user'
        managed = False  # Assuming table is managed outside Django migrations