from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from account.models import Account
# from serp.models import Usersettings, Keyword, clientTracker 
from rest_framework.authtoken.admin import (TokenProxy)
from rest_framework.authtoken.models import Token
from django.utils.html import format_html 

class AccountAdmin(UserAdmin):
    list_display = ('id', 'email','username', 'date_joined', 'last_home_visit')
    search_fields = ('email','username',)
    readonly_fields=('date_joined', 'last_home_visit') 
    filter_horizontal = ()
    list_filter = ("date_joined", 'last_home_visit', "email")  
    fieldsets = ()
    list_per_page = 100 
    list_display_links = None
    actions = None
    def has_add_permission(self, request):
        return False
    def has_change_permission(self, request):
        return False
    
admin.site.register(Account, AccountAdmin)

#admin module unregister 
# admin.site.unregister(Token)

admin.site.unregister(TokenProxy)

class TokenAdmin(admin.ModelAdmin):
    list_display = ('user_id', 'key', 'created')
    readonly_fields=('user_id', 'key', 'created')
    list_filter = ("user_id","created")
    list_per_page = 20
    actions = None
    list_display_links = None    
    def has_add_permission(self, request):
        return False
    def has_change_permission(self, request):
        return False
      
admin.site.register(Token, TokenAdmin)


