from djongo import models
from account.models import Account
from django.conf import settings
from datetime import datetime


class clientTracker(models.Model):
    fb_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)
    client_ip = models.CharField(max_length=60, null=True)
    client_agent = models.TextField(null=True)
    time_zone = models.CharField(max_length=50, null=True)
    country_code = models.CharField(max_length=5, null=True)
    country = models.CharField(max_length=70, null=True)
    region = models.CharField(max_length=100, null=True)
    city = models.CharField(max_length=100, null=True)
    mobile = models.BooleanField(default=0)
    other_info = models.JSONField(default={})
    status = models.CharField(max_length=6, null=True)  # START, BUSY, FAIL, DONE
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    modified_date = models.DateTimeField(auto_now_add=False, auto_now=True)
    user_automation_time = models.DateTimeField(null=True)

    class Meta:
        db_table = "account_tracker"


class Keyword(models.Model):
    ### FOREIGN FIELDS ###
    fk_group = models.ForeignKey("Groups", on_delete=models.CASCADE, default=1)
    fk_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)

    ### OTHER FIELDS ###
    keyword = models.TextField()
    site_url = models.TextField()
    target = models.TextField(null=True)
    platform = models.CharField(max_length=10)
    exactdomain = models.BooleanField(default=0)

    # Location, Region and Language Fields
    location = models.TextField(null=True)
    isocode = models.CharField(max_length=5)
    region = models.CharField(max_length=20)
    language = models.CharField(max_length=15)
    language_code = models.CharField(max_length=8, null=True)
    location_code = models.IntegerField(default=2840)

    # Stats
    ranknow = models.IntegerField(default=0)
    search_volume = models.CharField(max_length=50, default="NA")
    keyword_difficulty = models.CharField(max_length=50, default="NA")
    search_intent = models.CharField(max_length=50, default="NA")
    cpc = models.CharField(max_length=50, default="NA")
    traffic = models.CharField(max_length=50, default="NA")
    ranked_url = models.CharField(max_length=50, default="NA")
    rank_trend = models.CharField(max_length=5, default="NA")

    # Historical Data
    rank = models.JSONField(blank=True, default=[])
    rank_history = models.JSONField(blank=True, default=[])
    search_volume_data = models.JSONField(blank=True, default=[])
    keyword_suggestions = models.JSONField(blank=True, default=[])

    track_status = models.CharField(max_length=50, default="INIT")  # INIT, SCHD, COMP, FAIL
    metric_status = models.CharField(max_length=50, default="INIT")  # INIT, SCHD, COMP, FAIL

    rank_sincestart = models.IntegerField(default=0)
    top_rank = models.IntegerField(default=0)

    # Date Fields
    created_date = models.DateTimeField(auto_now_add=True)
    updated_date = models.DateTimeField(auto_now_add=False, auto_now=True)
    modified_date = models.DateTimeField()
    lastranked_date = models.DateTimeField()

    # Day, Halfmonth, Month and Year Value, Status & Mark Comparison.
    dayval = models.IntegerField(default=0)
    weekval = models.IntegerField(default=0)
    monthval = models.IntegerField(default=0)
    halfmonthval = models.IntegerField(default=0)
    daymark = models.CharField(max_length=5)
    weekmark = models.CharField(max_length=5)
    monthmark = models.CharField(max_length=5)
    halfmonthmark = models.CharField(max_length=5, default="-")
    status_from_start = models.CharField(max_length=5)

    # Automation Status Call Fields
    auto_refresh_count = models.IntegerField(null=True, blank=True, default=0)
    auto_call_status = models.CharField(max_length=5, default="done")

    # Url Fields
    crawlurl = models.TextField(default="-")
    page_uuid_url = models.TextField(default="-")
    page_uuid = models.TextField(default="-")

    class Meta:
        db_table = "keyword"


class Groups(models.Model):
    fk_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)  # foriegn key
    group_name = models.CharField(max_length=100)
    domain_name = models.CharField(max_length=500, null=True)
    project_automation_time = models.DateTimeField(null=True)
    group_call_status = models.CharField(max_length=5, default="INIT")
    track_status = models.CharField(max_length=50, default="INIT")  # INIT, SCHD, COMP, FAIL
    metric_status = models.CharField(max_length=50, default="INIT")  # INIT, SCHD, COMP, FAIL
    group_call_start = models.DateTimeField(auto_now_add=False, auto_now=True)
    group_call_end = models.DateTimeField(auto_now_add=False, auto_now=True)
    uptrend_cnt = models.IntegerField(default=0)
    downtrend_cnt = models.IntegerField(default=0)
    keyword_difficulty = models.CharField(max_length=50, default="NA")
    # Auto updated when data is inserted
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    # Auto updated when the data is altered
    updated_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    def __str__(self):
        return self.group_name

    class Meta:
        db_table = "group"


class Region(models.Model):
    region_name = models.CharField(max_length=30)
    region_code = models.CharField(max_length=3)
    region_country = models.CharField(max_length=100)
    searchvolume_country_id = models.CharField(max_length=100, default="")
    # Auto updated when data is inserted
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    # Auto updated when the data is altered
    updated_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    def __str__(self):
        return self.region_name

    class Meta:
        db_table = "region"


class Language(models.Model):
    language_name = models.CharField(max_length=100)
    language_code = models.CharField(max_length=10)
    # Auto updated when data is inserted
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    # Auto updated when the data is altered
    updated_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    def __str__(self):
        return self.language_name

    class Meta:
        db_table = "language"


class Accountusage(models.Model):
    fb_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)
    plan_keyword_limit = models.IntegerField(default=0)
    plan_project_limit = models.IntegerField(default=1)
    status = models.CharField(max_length=100)
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    modified_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    class Meta:
        db_table = "accountusage"


class Settings(models.Model):
    core_mode = models.BooleanField(default=1)
    core_manual_mail = models.BooleanField(default=1)
    results_per_page = models.IntegerField(default=100)
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    modified_date = models.DateTimeField(auto_now_add=False, auto_now=True)
    core_refresh_time = models.DateField(auto_now_add=True)
    daily_automation_count = models.JSONField(blank=True, default=[])

    proxy_maximum_load_limit = models.IntegerField(default=1000)
    proxy_success_count = models.IntegerField(default=0)
    proxy_exceeds_count = models.IntegerField(default=0)
    proxy_invalid_count = models.IntegerField(default=0)
    proxy_reset_counter = models.IntegerField(default=0)

    class Meta:
        db_table = "mainsettings"


# ALTERNATIVE VOLUME TABLE FOR KEYWORDS
class keywordMetrics(models.Model):
    fk_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)
    fk_group = models.ForeignKey("Groups", on_delete=models.CASCADE)
    fk_keyword = models.ForeignKey("Keyword", on_delete=models.CASCADE)

    keyword = models.TextField()
    keyword_slug = models.TextField()
    region_name = models.CharField(max_length=20)
    region_code = models.CharField(max_length=8, null=True)
    searchvolume_country_id = models.CharField(max_length=8, null=True)

    status = models.CharField(max_length=10, default="new")  # (- / 'done','month','not','fail')
    month_wise_volume = models.JSONField(blank=True, default=[])
    past_months = models.JSONField(blank=True, default=[])
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    modified_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    class Meta:
        db_table = "keyword_metrics"


# Competitor table
class Competitors(models.Model):
    fk_user = models.ForeignKey("account.Account", on_delete=models.CASCADE)
    fk_group = models.ForeignKey("Groups", on_delete=models.CASCADE)
    url = models.TextField()
    keywords = models.JSONField(blank=True, default=[])
    track_status = models.CharField(max_length=50, default="INIT")
    created_date = models.DateTimeField(auto_now_add=True, auto_now=False)
    modified_date = models.DateTimeField(auto_now_add=False, auto_now=True)

    class Meta:
        db_table = "competitors"
