"""
Django settings for Rankmax project.

Generated by 'django-admin startproject' using Django 3.2.25.

For more information on this file, see
https://docs.djangoproject.com/en/3.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.2/ref/settings/
"""

try:
    import os
    from datetime import date, datetime, timedelta
    from pathlib import Path

    # from google.ads.googleads.client import GoogleAdsClient
    # from google.ads.googleads.errors import GoogleAdsException

    # Build paths inside the project like this: BASE_DIR / 'subdir'.
    BASE_DIR = Path(__file__).resolve().parent.parent

    # Quick-start development settings - unsuitable for production
    # See https://docs.djangoproject.com/en/3.2/howto/deployment/checklist/

    # SECURITY WARNING: keep the secret key used in production secret!
    SECRET_KEY = "django-insecure-+np*zh%bxe=sicr&#m12#nwprv1)ama_kuhjtz@dj(7&&*q36("

    # SECURITY WARNING: don't run with debug turned on in production!
    DEBUG = True

    # Media Settings
    MEDIA_URL = "/media/"
    MEDIA_ROOT = os.path.join(BASE_DIR, "media")

    # Ensure the directory exists
    if not os.path.exists(MEDIA_ROOT):
        os.makedirs(MEDIA_ROOT)

    ALLOWED_HOSTS = ["localhost", "127.0.0.1", "ranktracker.theseotrends.com"]

    # Application definition

    INSTALLED_APPS = ["django.contrib.admin", "django.contrib.auth", "django.contrib.contenttypes", "django.contrib.sessions", "django.contrib.messages", "django.contrib.staticfiles", "rest_framework", "corsheaders", "rest_framework.authtoken", "dj_rest_auth", "django_crontab", "account", "serp","account_pg"]

    AUTH_USER_MODEL = "account.Account"

    REST_FRAMEWORK = {
        # "EXCEPTION_HANDLER": "glassend.views.custom_exception_handler",
        "DEFAULT_AUTHENTICATION_CLASSES": (
            "rest_framework.authentication.TokenAuthentication",
            "rest_framework.authentication.BasicAuthentication",
            "rest_framework.authentication.SessionAuthentication",
        ),
        "DEFAULT_PERMISSION_CLASSES": ("rest_framework.permissions.IsAuthenticated",),
    }

    JWT_AUTH = {
        "JWT_AUTH_HEADER_PREFIX": "Token",
    }

    STATIC_ROOT = os.path.join(BASE_DIR, "static")

    MIDDLEWARE = [
        "django.middleware.security.SecurityMiddleware",
        "django.contrib.sessions.middleware.SessionMiddleware",
        "django.middleware.common.CommonMiddleware",
        "django.middleware.csrf.CsrfViewMiddleware",
        "django.contrib.auth.middleware.AuthenticationMiddleware",
        "django.contrib.messages.middleware.MessageMiddleware",
        "django.middleware.clickjacking.XFrameOptionsMiddleware",
        "corsheaders.middleware.CorsMiddleware",
    ]

    CRONJOBS = [
        # ("30 23 */3 * *", "serp.register_token.user_reg_token_expiry"),
    ]

    CORS_ORIGIN_ALLOW_ALL = True

    SECURE_PROXY_SSL_HEADER = ("HTTP_X_FORWARDED_PROTO", "https")
    SECURE_SSL_REDIRECT = False
    SESSION_COOKIE_SECURE = True
    CSRF_COOKIE_SECURE = True

    # CSRF_COOKIE_HTTPONLY = True

    CORS_ORIGIN_WHITELIST = ("http://127.0.0.1:8000", "http://localhost:8000")

    ROOT_URLCONF = "ranker.urls"

    APPEND_SLASH = True

    TEMPLATES = [
        {
            "BACKEND": "django.template.backends.django.DjangoTemplates",
            "DIRS": [],
            "APP_DIRS": True,
            "OPTIONS": {
                "context_processors": [
                    "django.template.context_processors.debug",
                    "django.template.context_processors.request",
                    "django.contrib.auth.context_processors.auth",
                    "django.contrib.messages.context_processors.messages",
                ],
            },
        },
    ]

    WSGI_APPLICATION = "ranker.wsgi.application"

    # DATABASES = {
    #     "default": {
    #         "ENGINE": "djongo",
    #         "NAME": "ranktracker",
    #         "ENFORCE_SCHEMA": False,
    #         "CLIENT": {
    #             "host": "mongodb://localhost:27017",
    #         },
    #     },
    # }
    DATABASES = {
    "default": {
        "ENGINE": "djongo",
        "NAME": "ranker",  # This should match the database name in your Atlas cluster
        "ENFORCE_SCHEMA": False,
        "CLIENT": {
               "host": "mongodb://ranktracker:phOba5%408xec%23%24r%23fls%23o@24.144.71.205:27017/ranker?authSource=admin&authMechanism=SCRAM-SHA-1"
        },
        #   "CLIENT": {
        #        "host": "mongodb://127.0.0.1:27017/ranker"
        # },
    },
        'postgresql': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': 'theseotrendsdb',
        'USER': 'theseotrendsuser',
        'PASSWORD': 'T72VoPh_wacR-suchusu',
        'HOST': '24.144.71.205',
        'PORT': '5432',
    }
}


    # Password validation
    # https://docs.djangoproject.com/en/3.2/ref/settings/#auth-password-validators

    AUTH_PASSWORD_VALIDATORS = [
        {
            "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
        },
        {
            "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
        },
        {
            "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
        },
        {
            "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
        },
    ]

    # Static files (CSS, JavaScript, Images)
    # https://docs.djangoproject.com/en/3.2/howto/static-files/

    STATIC_URL = "/static/"

    # Default primary key field type
    # https://docs.djangoproject.com/en/3.2/ref/settings/#default-auto-field

    DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"

    ################################### TIMEZONE SETTINGS STARTS ###################################

    # Internationalization
    # https://docs.djangoproject.com/en/3.2/topics/i18n/

    LANGUAGE_CODE = "en-us"

    DEF_LOCATION = "United States"

    TIME_ZONE = "Asia/Kolkata"

    USE_I18N = True

    USE_L10N = True

    USE_TZ = True

    #################################### TIMEZONE SETTINGS ENDS ####################################
    #
    #
    #
    ################################## GENERAL APP SETTINGS STARTS ##################################

    SITE_URL = "https://app.rankmax.io"

    SERVICE_URL = "https://api.rankmax.io/"

    ################################### GENERAL APP SETTINGS ENDS ###################################
    #
    #
    #
    ################################## EMAIL AUTHENTICATION STARTS ##################################

    EMAIL_BACKEND = "django.core.mail.backends.smtp.EmailBackend"

    EMAIL_USE_SSL = True

    EMAIL_HOST = "smtp.zeptomail.in"

    EMAIL_HOST_USER = "emailapikey"

    HOST_MAIL = "Rankmax <info@rankmax.io>"

    ADMIN_MAIL = ["abulkalam@appkodes.com"]

    EMAIL_HOST_PASSWORD = "PHtE6r1eF7i5gzYs80MB5KLqQsL3Mdkp+Lw2eAdE4oYXXKMFHU1Sqd9+lzG3/0gsVfkXR//KzYw8ub2ZtuKNJGa4PGdKVGqyqK3sx/VYSPOZsbq6x00UtVgYcUHbXIfvc9Rj0y3VuNaX"

    EMAIL_PORT = 465

    DEFAULT_FROM_EMAIL = EMAIL_HOST_USER  # MANDATORY

    ################################## EMAIL AUTHENTICATION ENDS ##################################
    #
    #
    #
    ################################## SEARCH VOLUME DEFAULT STARTS ##################################

    _DEFAULT_LOCATION_IDS = ["2840"]
    _DEFAULT_LANGUAGE_ID = "1000"

    ################################## SEARCH VOLUME DEFAULT ENDS ##################################
    #
    #
    #
    ####################### GOOGLE ACCOUNT CONFIGURATION AND SETTINGS STARTS #########################

    CUSTOMER_ID = "1349094197"
    CUSTOMER_ID_2 = "5646228594"  # serppleresearch@gmail.com
    CUSTOMER_ID_3 = "1021870396"  # serptest2022@gmail.com

    # GOOGLEADS_CLIENT = GoogleAdsClient.load_from_storage(str(BASE_DIR) + "/files/google-ads.yaml")
    # GOOGLEADS_CLIENT_2 = GoogleAdsClient.load_from_storage(str(BASE_DIR) + "/files/google-ads-2.yaml")
    # GOOGLEADS_CLIENT_3 = GoogleAdsClient.load_from_storage(str(BASE_DIR) + "/files/google-ads-3.yaml")

    ######################## GOOGLE ACCOUNT CONFIGURATION AND SETTINGS ENDS #########################

except Exception as e:
    searchFile = os.getcwd() + "/logs/app.log"

    if not os.path.exists(searchFile):
        with open(searchFile, "w"):
            pass
    with open(searchFile, "r+") as f:
        content = f.read()
        f.seek(0, 0)
        f.write(str(datetime.strftime(datetime.now(), "GMT %b|%d|%Y-%H:%M:%S")) + " => " + str(e).rstrip("\r\n") + "\n" + content)
