from datetime import datetime


def safe_round(value):
    if value and value not in ["NA"]:
        return round(float(value))
    else:
        return value


def capitalized_word(text):
    if text == "NA":
        return text
    return text.capitalize()


def search_volume_labels(data):
    if data:
        # Convert to formatted arrays
        data = data[:12]
        return [datetime(entry["year"], entry["month"], 1).strftime("%b %y") for entry in data]
    else:
        return []


def search_volume_values(data):
    if data:
        data = data[:12]
        # Convert to formatted arrays
        return [entry["search_volume"] for entry in data]
    else:
        return []


def rank_history_labels(data):
    """
    Converts rank history entries into labels like '29 Apr 25' based on actual date in each entry.
    """
    if not data:
        return []

    data = data[:30]

    return [datetime(entry["year"], entry["month"], entry["date"]).strftime("%-d %b %y") for entry in data]


def rank_history_values(data):
    if data:
        data = data[:30]
        return [entry.get("rank") for entry in data]
    else:
        return []
