import { verifyToken } from "../utils/jwt.js";

export function authenticateUser(req, res, next) {
  try {
    // Get token from cookies or Authorization header
// console.log(req.headers.access_token,"accestoken data")
    const token = req.headers.access_token;
    // console.log("Token:", token);
    if (!token) {
      return res.status(401).json({ error: "Unauthorized: No token provided" });
    }
    // Verify the token

    // Verify the token


    const decoded = verifyToken(token);
// console.log("Decoded Token:", decoded);
    // Attach user data to request object
    req.user = decoded;

    next(); // Proceed to the next middleware
  } catch (error) {
    console.error("Auth Error:", error.message);

    // Handle token-specific errors
    if (error.name === "TokenExpiredError") {
      return res
        .status(403)
        .json({ error: "Token expired. Please login again." });
    }
    if (error.name === "JsonWebTokenError") {
      return res.status(403).json({ error: "Invalid token." });
    }

    return res.status(500).json({ error: "Internal Server Error" || error.message });
  }
}
